/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRCapes;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.animal.LOTREntityWildBoar;
import lotr.common.entity.npc.LOTREntityEreborDwarf;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRMercenary;
import lotr.common.entity.npc.LOTRNPCMount;
import lotr.common.fac.LOTRFaction;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityEreborGuardCrossbow
extends LOTREntityEreborDwarf
implements LOTRMercenary {
    public LOTREntityEreborGuardCrossbow(World world) {
        super(world);
        this.npcCape = LOTRCapes.ALIGNMENT_DWARF.capeTexture;
        this.spawnRidingHorse = this.field_70146_Z.nextInt(3) == 0;
    }

    @Override
    public LOTRNPCMount createMountToRide() {
        LOTREntityWildBoar boar = new LOTREntityWildBoar(this.field_70170_p);
        boar.setMountArmor(new ItemStack(LOTRMod.boarArmorDwarfMithril));
        return boar;
    }

    @Override
    public EntityAIBase getDwarfAttackAI() {
        return new LOTREntityAIRangedAttack(this, 1.4, 30, 50, 16.0f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(npcRangedAccuracy).func_111128_a(0.85);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setRangedWeapon(new ItemStack(LOTRMod.dwarvenCrossbow));
        this.npcItemsInv.setIdleItem(this.npcItemsInv.getRangedWeapon());
        this.func_70062_b(1, new ItemStack(LOTRMod.bootsEreborMithril));
        this.func_70062_b(2, new ItemStack(LOTRMod.legsEreborMithril));
        this.func_70062_b(3, new ItemStack(LOTRMod.bodyEreborMithril));
        this.func_70062_b(4, new ItemStack(LOTRMod.helmetEreborMithril));
        return data;
    }

    @Override
    public void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getRangedWeapon());
        }
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float f) {
        this.npcCrossbowAttack(target, f);
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        this.dropNPCCrossbowBolts(i);
    }

    @Override
    public LOTRFaction getHiringFaction() {
        return LOTRFaction.DURINS_FOLK;
    }

    @Override
    public int getMercBaseCost() {
        return 40;
    }

    @Override
    public float getMercAlignmentRequired() {
        return 250.0f;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getData(entityplayer).getAlignment(this.getFaction()) >= 0.0f && this.isFriendly(entityplayer);
    }

    @Override
    public void onUnitTrade(EntityPlayer entityplayer) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.hireEreborMercenary);
    }
}

